#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_VBECSDateTime : BaseTest 
	{

		[SetUp]
		protected void SetUp() 
		{	
			this.BaseSetUp();
		}

		[Test]
		public void CompareDates_Pass()
		{
			System.DateTime date = System.DateTime.Now;

			int i = VBECSDateTime.CompareDates(date,date);
			Assert.AreEqual(i,0);

			System.DateTime dateLater = date.AddHours(1);

			int j = VBECSDateTime.CompareDates(date,dateLater);
			Assert.AreEqual(j,-1);

			int k = VBECSDateTime.CompareDates(dateLater,date);
			Assert.AreEqual(k,1);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CompareDates_Fail()
		{
		}

		[Test]
		public void DateFormat_Pass()
		{
			Assert.IsTrue(Common.VBECSDateTime.DateFormat == Common.VbecsConfig.Current.DateFormat);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DateFormat_Fail()
		{
		}

		[Test]
		public void DateTimeFormat_Pass()
		{
			Assert.IsTrue(Common.VBECSDateTime.DateTimeFormat == Common.VbecsConfig.Current.DateTimeFormat);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DateTimeFormat_Fail()
		{
		}

		[Test]
		public void DateTimeLongFormat_Pass()
		{
			Assert.IsTrue(Common.VBECSDateTime.DateTimeLongFormat == Common.VbecsConfig.Current.LongDateTimeFormat);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DateTimeLongFormat_Fail()
		{
		}

		[Test]
		public void TimeFormat_Pass()
		{
			Assert.IsTrue(Common.VBECSDateTime.TimeFormat == Common.VbecsConfig.Current.TimeFormat);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TimeFormat_Fail()
		{
		}

		[Test]
		public void TimeLongFormat_Pass()
		{
			Assert.IsTrue(Common.VBECSDateTime.TimeLongFormat == Common.VbecsConfig.Current.LongTimeFormat);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TimeLongFormat_Fail()
		{
		}

		[Test]
		public void FormatDateString_String_Pass()
		{
			System.DateTime tmpDate = System.DateTime.Now;
			string tmpValue = tmpDate.ToString();

			Assert.IsTrue(Common.VBECSDateTime.FormatDateString(tmpValue) == tmpDate.ToString(Common.VBECSDateTime.DateFormat));
		}

		[Test]
		public void FormatDateString_String_Fail()
		{
			Assert.IsTrue(Common.VBECSDateTime.FormatDateString(string.Empty) == string.Empty);
		}

		[Test]
		public void FormatDateString_Object_Pass()
		{
			System.DateTime tmpDate = System.DateTime.Now;
			object tmpValue = tmpDate;

			Assert.IsTrue(Common.VBECSDateTime.FormatDateString(tmpValue) == tmpDate.ToString(Common.VBECSDateTime.DateFormat));
		}

		[Test]
		public void FormatDateString_Object_Fail()
		{
			object tmpValue = null;
			Assert.IsTrue(Common.VBECSDateTime.FormatDateString(tmpValue) == string.Empty);
			tmpValue = DBNull.Value;
			Assert.IsTrue(Common.VBECSDateTime.FormatDateString(tmpValue) == string.Empty);
		}

		[Test]
		public void FormatDateTimeString_String_Pass()
		{
			System.DateTime tmpDate = System.DateTime.Now;
			object tmpValue = tmpDate;

			Assert.IsTrue(Common.VBECSDateTime.FormatDateTimeString(tmpValue) == tmpDate.ToString(Common.VBECSDateTime.DateTimeFormat));
		}

		[Test]
		public void FormatDateTimeString_String_Fail()
		{
			Assert.IsTrue(Common.VBECSDateTime.FormatDateTimeString(string.Empty) == string.Empty);
		}

		[Test]
		public void FormatDateTimeString_Object_Pass()
		{
			System.DateTime tmpDate = System.DateTime.Now;
			object tmpValue = tmpDate;

			Assert.IsTrue(Common.VBECSDateTime.FormatDateTimeString(tmpValue) == tmpDate.ToString(Common.VBECSDateTime.DateTimeFormat));
		}

		[Test]
		public void FormatDateTimeString_Object_Fail()
		{
			object tmpValue = null;
			Assert.IsTrue(Common.VBECSDateTime.FormatDateTimeString(tmpValue) == string.Empty);
			tmpValue = DBNull.Value;
			Assert.IsTrue(Common.VBECSDateTime.FormatDateTimeString(tmpValue) == string.Empty);
		}

		[Test]
		public void FormatDateLongTimeString_String_Pass()
		{
			System.DateTime tmpDate = System.DateTime.Now;
			object tmpValue = tmpDate;

			Assert.IsTrue(Common.VBECSDateTime.FormatDateLongTimeString(tmpValue) == tmpDate.ToString(Common.VBECSDateTime.DateTimeLongFormat));
		}

		[Test]
		public void FormatDateLongTimeString_String_Fail()
		{
			Assert.IsTrue(Common.VBECSDateTime.FormatDateLongTimeString(string.Empty) == string.Empty);
		}

		[Test]
		public void FormatDateLongTimeString_Object_Pass()
		{
			System.DateTime tmpDate = System.DateTime.Now;
			object tmpValue = tmpDate;

			Assert.IsTrue(Common.VBECSDateTime.FormatDateLongTimeString(tmpValue) == tmpDate.ToString(Common.VBECSDateTime.DateTimeLongFormat));
		}

		[Test]
		public void FormatDateLongTimeString_Object_Fail()
		{
			object tmpValue = null;
			Assert.IsTrue(Common.VBECSDateTime.FormatDateLongTimeString(tmpValue) == string.Empty);
			tmpValue = DBNull.Value;
			Assert.IsTrue(Common.VBECSDateTime.FormatDateLongTimeString(tmpValue) == string.Empty);
		}

	}

}
#endif

